package test;

/**
 * Write a description of class Test here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */

import java.util.Scanner;

import art.Artist;
import art.Poet;
import music.Album;
import music.Compilation;
import music.EmptyPlaylistException;
import music.Musician;
import music.Performer;
import music.Playlist;
import music.Song;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;

public class Test {
    
    public static final Scanner IN = new Scanner(System.in);
    
    public void testPrintln() {
        System.out.println("Hi :)");
    }
    
    public void testPerformer() {
        // Performer weezer = new Performer();
        // weezer.name = "Weezer"; // No way! name has private access!
        Performer theBeatles = new Performer();
        theBeatles.setName("The Beatles");
        System.out.println(theBeatles.getName());
        System.out.println(theBeatles.getAge());
        System.out.println(theBeatles.getOrigin());
    }
    
    public void testAlbum() {
        Performer theBeatles = new Performer("The Beatles", 0, "UK");
        Album sgtPepper = new Album("Sgt. Pepper's Lonely Hearts Club Band", 
                                     1967, theBeatles);
        System.out.println(sgtPepper.getTitle());
    }
    
    public void testArrays() {
        // double[] d = new double[44];
        // for (int i = 0; i < d.length; i++) {
            // d[i] = i + 1;
            // // if (i == 2) {
                // // // continue;
                // // break;
            // // }
            // System.out.println('\t' + "d[" + i + "] = " + d[i]);
        // }
        // double[] d = new double[4];
        // int i = 0;
        // while (i < 4) {
            // d[i] = i + 1;
            // // if (i == 2) {
                // // // continue;
                // // break;
            // // }
            // System.out.println('\t' + "d[" + i + "] = " + d[i]);
            // i++;
        // }
        
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        Song withALittleHelp = new Song("With a Little Help from My Friends", 136);
        Song lucy = new Song("Lucy in the Sky with Diamonds", 126);
        
        // Song[] songs = new Song[3];
        // songs[0] = sgtPepper;
        // songs[1] = withALittleHelp;
        // songs[2] = lucy;
        Song[] songs = {sgtPepper, withALittleHelp, lucy};
    }
    
    public void testStringLength() {
        Album sgtPepper = new Album();
        sgtPepper.setTitle("");
    }
    
    public void testAlbumWithSongs() {
        Performer theBeatles = new Performer("The Beatles", 0, "UK");
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        Song withALittleHelp = new Song("With a Little Help from My Friends", 136);
        Song lucy = new Song("Lucy in the Sky with Diamonds", 126);
        Song[] songs = {sgtPepper, withALittleHelp, lucy};
        
        // Album sgt = new Album("Sgt. Pepper's Lonely Hearts Club Band", 
                                     // 1967, theBeatles, songs);
        // for (int i = 0; i < sgt.getSongs().length; i++) {
            // System.out.println(sgt.getSongs()[i].getTitle());
        // }
        
        Album sgt = new Album("Sgt. Pepper's Lonely Hearts Club Band", 
                                     1967, theBeatles, 3);
        for (int i = 0; i < sgt.getSongs().length; i++) {
            System.out.println(sgt.getSongs()[i].getTitle());
        }
    }
    
    public void testStatic() {
        Song.define();
        
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        System.out.println(sgtPepper.getDefinition());
        System.out.println();
        System.out.println();

        Song withALittleHelp = new Song("With a Little Help from My Friends", 136);
        Song lucy = new Song("Lucy in the Sky with Diamonds", 126);
        
        // sgtPepper.setDefinition("A nice piece of music");
        System.out.println(sgtPepper.getDefinition());
        
        System.out.println();
        
        System.out.println(withALittleHelp.getDefinition());
    }
    
    public void testSwitch() {
        int a = 0;
        switch (a) {
            case 0: System.out.println(0); break;
            case 3: System.out.println(3); break;
            default: System.out.println("None of the above...");
        }
    }
    
    public void testToString() {
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        System.out.println(sgtPepper);
    }
    
    public void testKeyboardInput() {
        System.out.print("Read a line: ");
        String s = IN.nextLine();
        System.out.println("You entered: " + s);
    }
    
    public void testStrings() {
        // String theBeatles = "The Beatles";
        // String a = new String("b");
        char[] theAsCharArray = {'T', 'h', 'e'};
        System.out.println(theAsCharArray);
        String the = new String(theAsCharArray);
        Album a = new Album();
        System.out.println(a);
        // String theBeatles = new String("The Beatles");
        // System.out.println(theBeatles);
        String theBeatles = the.concat(" Beatles");
        System.out.println(theBeatles);
        System.out.println(theBeatles.charAt(4));
        System.out.println(theBeatles.compareTo("the Beatles"));
        System.out.println(theBeatles.endsWith("Beatles"));
        String[] theBeatlesAsStringArray = theBeatles.split(" ");
        for (int i = 0; i < theBeatlesAsStringArray.length; i++) {
            System.out.println(theBeatlesAsStringArray[i]);
        }
        
        StringBuffer sb1 = new StringBuffer();
        sb1.append("The Rolling Stones");
        
        StringBuffer sb = new StringBuffer("The Beatles");
        System.out.println(sb);
        sb.append(" are the greatest phenomenon of the XX century.");
        System.out.println(sb);
        // sb.append(28);
        sb.append(28).delete(23, 28).insert(23, "ffff");
        System.out.println(sb);
    }
    
    public void testArrayLists() {
        Performer theBeatles = new Performer("The Beatles", 0, "UK");
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        Song withALittleHelp = new Song("With a Little Help from My Friends", 136);
        Song lucy = new Song("Lucy in the Sky with Diamonds", 126);
        Song[] songs = {sgtPepper, withALittleHelp, lucy};
        ArrayList<String> credits = new ArrayList<String>();
        credits.add("George Martin");
        credits.add("Norman Smith");
        
        Album sgt = new Album("Sgt. Pepper's Lonely Hearts Club Band", 
                                     1967, theBeatles, songs, credits);
                                     
        sgt.prettyPrint();
        
        sgt.getCredits().remove(0);
        sgt.prettyPrint();
        
    }
    
    public void testGregorianClandar() {
        GregorianCalendar gc = new GregorianCalendar();
        System.out.println(gc);
        
        GregorianCalendar releaseDate = new GregorianCalendar(1967, GregorianCalendar.JUNE, 1);
        Performer theBeatles = new Performer("The Beatles", 0, "UK");
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        Song withALittleHelp = new Song("With a Little Help from My Friends", 136);
        Song lucy = new Song("Lucy in the Sky with Diamonds", 126);
        Song[] songs = {sgtPepper, withALittleHelp, lucy};
        ArrayList<String> credits = new ArrayList<String>();
        credits.add("George Martin");
        credits.add("Norman Smith");
        
        Album sgt = new Album("Sgt. Pepper's Lonely Hearts Club Band", 
                                     1967, theBeatles, songs, credits, releaseDate);
                                     
        sgt.prettyPrint();
        
        System.out.println();
        
        Song comeTogether = new Song("Come Together", 183);
        Song ohDarling = new Song("Oh, Darling", 160);
        Song[] songs1 = {comeTogether, ohDarling};
        GregorianCalendar releaseDate1 = new GregorianCalendar(1969, GregorianCalendar.SEPTEMBER, 26);
        
        Album abbeyRoad = new Album("Abbey Road", 
                                     1969, theBeatles, songs1, credits, releaseDate1);
        abbeyRoad.prettyPrint();
        
        System.out.println();
        
        System.out.println("Is Abbey Road released after Sgt. Pepper?");
        if (abbeyRoad.getReleaseDate().after(sgt.getReleaseDate())) {
            System.out.println("Yes, after...");
        } else {
            System.out.println("No, before...");
        }
    }
    
    public void testInheritance() {
        GregorianCalendar releaseDate = new GregorianCalendar(1972, GregorianCalendar.MAY, 23);
        Performer various = new Performer("VA", 1000, "UK, US");
        Song louie = new Song("Louie, Louie", 123);
        Song dirtyWater = new Song("Dirty Water", 136);
        Song[] songs = {louie, dirtyWater};
        ArrayList<String> credits = new ArrayList<String>();
        credits.add("Lenny Kaye");
        
        Compilation nuggets = new Compilation("Nuggets", 
                                     1972, various, songs, credits, releaseDate, 100);
                                     
        nuggets.prettyPrint();
        
        GregorianCalendar releaseDate1 = new GregorianCalendar(1967, GregorianCalendar.JUNE, 1);
        Performer theBeatles = new Performer("The Beatles", 0, "UK");
        Song sgtPepper = new Song("Sgt. Pepper's Lonely Hearts Club Band", 123);
        Song withALittleHelp = new Song("With a Little Help from My Friends", 136);
        Song lucy = new Song("Lucy in the Sky with Diamonds", 126);
        Song[] songs1 = {sgtPepper, withALittleHelp, lucy};
        ArrayList<String> credits1 = new ArrayList<String>();
        credits.add("George Martin");
        credits.add("Norman Smith");
        
        Album sgt = new Album("Sgt. Pepper's Lonely Hearts Club Band", 
                                     1967, theBeatles, songs1, credits1, releaseDate1);
                                     
        Album[] albums = new Album[2];
        albums[0] = sgt;
        albums[1] = nuggets;
        
        // albums[1].getNoOfPerformers();
        nuggets.getNoOfPerformers();
        
        // Compilation c = sgt;    // No, sgt is an Album object, a Compilation object is expected here!!!
        
        System.out.println();
        
        nuggets.prettyPrint();
        System.out.println();
        sgt.prettyPrint();
        
    }
    
    public void testObject() {
        Performer theBeatles = new Performer("The Beatles", 0, "UK");   	
        Performer theBeatles1 = new Performer("The Beatles", 0, "UK");
        
        if (theBeatles == theBeatles1) {
        	System.out.println("Same");
        } else {
        	System.out.println("Different");
        }
        
        if (theBeatles.equals(theBeatles1)) {
        	System.out.println("Same");
        } else {
        	System.out.println("Different");
        }
        
        System.out.println(theBeatles);
        System.out.println(theBeatles1);
    }
    
    public void testAbstractClass() {
//    	Musician m = new Musician();	// no, Musician is abstract
    	Musician m = new Performer();
    	
    	m.setGenre("blues");
    	System.out.println(m.getGenre());
    	
//    	System.out.println(m.getName());
    }
    
    public void testInterfaces() {
//    	Artist m = new Artist();
    	Artist m = new Performer();
    	m.describe();
    	
    	Artist edgarAllanPoe = new Poet("Edgar Allan Poe", "reflexive");
    	edgarAllanPoe.describe();
    }
    
    public void testExceptions() {
//    	String s = null;
//    	System.out.println(s.length());
//    	int[] a = {1, 2, 3};
//    	for (int i = 0; i <= a.length; i++) {
//			a[i] = i;
//			System.out.println(a[i]);
//		}
        Song louie = new Song("Louie, Louie", 123);
        Song dirtyWater = new Song("Dirty Water", 136);
//        List<Song> songs = new LinkedList<Song>();
//        songs.add(louie);
//        songs.add(dirtyWater);
        
//        Playlist playlist = new Playlist(songs);
        Playlist playlist = new Playlist();
        
        try {
			playlist.play();
		} catch (EmptyPlaylistException e) {
			// TODO Auto-generated catch block
//			System.err.println("Something");
			e.printStackTrace();
		}
    }
    
    public void testIO() {
    	
        Performer theBeatles = new Performer("The Beatles", 0, "UK", "Rock 'n' Roll");
        System.out.println(theBeatles);
        
        File f = new File("The Beatles.txt");
        
        System.out.println("Writing an object to a txt file...");
        
        try {
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
			out.println(theBeatles.getName());
			out.println(theBeatles.getAge());
			out.println(theBeatles.getOrigin());
			out.println(theBeatles.getGenre());
			out.flush();
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        
        System.out.println("Done.");

        Performer beatles = new Performer();
        
        System.out.println("Reading an object from a txt file...");
        System.out.print("Press ENTER to continue...");
        
        IN.nextLine();
        
        try {
			BufferedReader in = new BufferedReader(new FileReader(f));
			beatles.setName(in.readLine());
			beatles.setAge(Integer.parseInt(in.readLine()));
			beatles.setOrigin(in.readLine());
			beatles.setGenre(in.readLine());
			in.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        
        System.out.println(beatles);

    }

    public void testDataIO() {
    	
        Performer theBeatles = new Performer("The Beatles", 0, "UK", "Rock 'n' Roll");
        System.out.println(theBeatles);
        
        File f = new File("The Beatles.data");
        
        System.out.println("Writing an object to a binary file...");
        
        try {
			DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
			out.writeUTF(theBeatles.getName());
			out.writeInt(theBeatles.getAge());
			out.writeUTF(theBeatles.getOrigin());
			out.writeUTF(theBeatles.getGenre());
			out.flush();
			out.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        
        System.out.println("Done.");

        Performer beatles = new Performer();
        
        System.out.println("Reading an object from a binary file...");
        System.out.print("Press ENTER to continue...");
        
        IN.nextLine();
        
        try {
			DataInputStream in = new DataInputStream(new FileInputStream(f));
			beatles.setName(in.readUTF());
			beatles.setAge(in.readInt());
			beatles.setOrigin(in.readUTF());
			beatles.setGenre(in.readUTF());
			in.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        
        System.out.println(beatles);

    }

    public void testSerialization() {
    	
        Performer theBeatles = new Performer("The Beatles", 0, "UK", "Rock 'n' Roll");
        System.out.println(theBeatles);
        
        
        System.out.println("Serializing...");
        
        theBeatles.serialize("The Beatles.serialized");
        
        System.out.println("Done.");

    }
    
    public void testDesrialization() {
    	
        System.out.println("Deserializing...");
        Performer beatles = Performer.deserialize("The Beatles.serialized");
        System.out.println(beatles);

    }
}
